local Player = ...
assert(Player,"StepsDisplay needs Player")

local c
local pFlip = Player==PLAYER_2 and -1 or 1
local diffAlign = Player==PLAYER_2 and 1 or 0
local meterAlign = Player==PLAYER_2 and 0 or 1

local diffToFrame = {
	Difficulty_Beginner		= 0,
	Difficulty_Easy			= 1,
	Difficulty_Medium		= 2,
	Difficulty_Hard			= 3,
	Difficulty_Challenge	= 4,
	Difficulty_Edit			= 5
}

return Def.ActorFrame{
	InitCommand=function(self) c = self:GetChildren() end;
	BeginCommand=cmd(playcommand,"Set");
	SetCommand=function(self)
		local song = SongOrCourse()
		if song then
			if GAMESTATE:IsCourseMode() then
				-- handle course crap
				c.Difficulty:settext("unfinished")
				c.Meter:settext("0")
			else
				local steps = StepsOrTrail(Player)
				local st = steps:GetStepsType()
				local diff = steps:GetDifficulty()
				local cd = GetCustomDifficulty(st,diff,nil)
				-- custom difficulty
				c.Difficulty:settext(THEME:GetString("CustomDifficulty",cd))
				c.StepsType:settext(THEME:GetString("Panel",ToEnumShortString(st)))
				c.Meter:settext(steps:GetMeter())
				c.Frame:setstate(diffToFrame[diff])
			end
		end
	end;

	LoadActor(THEME:GetPathG("_gameplay","difficulty"))..{
		Name="Frame";
		InitCommand=cmd(x,32*pFlip;zoomx,pFlip;zoomy,0.85;pause);
	};
	LoadFont("_eurostile bold 24px")..{
		Name="Difficulty";
		InitCommand=cmd(xy,-20*pFlip,-8;zoom,0.5;halign,diffAlign;shadowlength,2;);
	};
	LoadFont("_eurostile bold 24px")..{
		Name="StepsType";
		InitCommand=cmd(xy,-20*pFlip,4;zoom,0.4;halign,diffAlign;shadowlength,2;);
	};
	LoadFont("_eurostile bold 24px")..{
		Name="Meter";
		InitCommand=cmd(x,84*pFlip;zoom,0.6;halign,meterAlign;shadowlength,2);
	};
};